Public Class frmOvenTest
  Inherits System.Windows.Forms.Form
  Private Const BROILTEMP = 550       ' Broiler temperature
  Private Const CLEANTEMP = 600       ' Self-clean temperature

  Dim MyOven As New COven()

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents Label1 As System.Windows.Forms.Label
  Friend WithEvents txtTemp As System.Windows.Forms.TextBox
  Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
  Friend WithEvents rbOvenOn As System.Windows.Forms.RadioButton
  Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
  Friend WithEvents rbOvenOff As System.Windows.Forms.RadioButton
  Friend WithEvents rbLightOff As System.Windows.Forms.RadioButton
  Friend WithEvents rbLightOn As System.Windows.Forms.RadioButton
  Friend WithEvents GroupBox3 As System.Windows.Forms.GroupBox
  Friend WithEvents rbDoorClosed As System.Windows.Forms.RadioButton
  Friend WithEvents rbDoorOpen As System.Windows.Forms.RadioButton
  Friend WithEvents btnUpdate As System.Windows.Forms.Button
  Friend WithEvents btnExit As System.Windows.Forms.Button
  Friend WithEvents txtOvenTemp As System.Windows.Forms.TextBox
  Friend WithEvents Label2 As System.Windows.Forms.Label
  Friend WithEvents rbBroil As System.Windows.Forms.RadioButton
  Friend WithEvents rbClean As System.Windows.Forms.RadioButton
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.Label1 = New System.Windows.Forms.Label()
    Me.txtTemp = New System.Windows.Forms.TextBox()
    Me.GroupBox1 = New System.Windows.Forms.GroupBox()
    Me.rbClean = New System.Windows.Forms.RadioButton()
    Me.rbBroil = New System.Windows.Forms.RadioButton()
    Me.rbOvenOff = New System.Windows.Forms.RadioButton()
    Me.rbOvenOn = New System.Windows.Forms.RadioButton()
    Me.GroupBox2 = New System.Windows.Forms.GroupBox()
    Me.rbLightOff = New System.Windows.Forms.RadioButton()
    Me.rbLightOn = New System.Windows.Forms.RadioButton()
    Me.GroupBox3 = New System.Windows.Forms.GroupBox()
    Me.rbDoorClosed = New System.Windows.Forms.RadioButton()
    Me.rbDoorOpen = New System.Windows.Forms.RadioButton()
    Me.btnUpdate = New System.Windows.Forms.Button()
    Me.btnExit = New System.Windows.Forms.Button()
    Me.txtOvenTemp = New System.Windows.Forms.TextBox()
    Me.Label2 = New System.Windows.Forms.Label()
    Me.GroupBox1.SuspendLayout()
    Me.GroupBox2.SuspendLayout()
    Me.GroupBox3.SuspendLayout()
    Me.SuspendLayout()
    '
    'Label1
    '
    Me.Label1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label1.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label1.Location = New System.Drawing.Point(8, 16)
    Me.Label1.Name = "Label1"
    Me.Label1.Size = New System.Drawing.Size(100, 20)
    Me.Label1.TabIndex = 0
    Me.Label1.Text = "Set Temp: "
    Me.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'txtTemp
    '
    Me.txtTemp.Location = New System.Drawing.Point(109, 16)
    Me.txtTemp.Name = "txtTemp"
    Me.txtTemp.Size = New System.Drawing.Size(64, 20)
    Me.txtTemp.TabIndex = 1
    Me.txtTemp.Text = "txtTemp"
    '
    'GroupBox1
    '
    Me.GroupBox1.Controls.AddRange(New System.Windows.Forms.Control() {Me.rbClean, Me.rbBroil, Me.rbOvenOff, Me.rbOvenOn})
    Me.GroupBox1.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.GroupBox1.Location = New System.Drawing.Point(8, 80)
    Me.GroupBox1.Name = "GroupBox1"
    Me.GroupBox1.Size = New System.Drawing.Size(272, 48)
    Me.GroupBox1.TabIndex = 4
    Me.GroupBox1.TabStop = False
    Me.GroupBox1.Text = "Oven Status:"
    '
    'rbClean
    '
    Me.rbClean.Location = New System.Drawing.Point(136, 24)
    Me.rbClean.Name = "rbClean"
    Me.rbClean.Size = New System.Drawing.Size(56, 16)
    Me.rbClean.TabIndex = 3
    Me.rbClean.Text = "&Clean"
    '
    'rbBroil
    '
    Me.rbBroil.Location = New System.Drawing.Point(72, 24)
    Me.rbBroil.Name = "rbBroil"
    Me.rbBroil.Size = New System.Drawing.Size(56, 16)
    Me.rbBroil.TabIndex = 2
    Me.rbBroil.Text = "B&roil"
    '
    'rbOvenOff
    '
    Me.rbOvenOff.Location = New System.Drawing.Point(208, 24)
    Me.rbOvenOff.Name = "rbOvenOff"
    Me.rbOvenOff.Size = New System.Drawing.Size(56, 16)
    Me.rbOvenOff.TabIndex = 1
    Me.rbOvenOff.Text = "O&ff"
    '
    'rbOvenOn
    '
    Me.rbOvenOn.Location = New System.Drawing.Point(8, 24)
    Me.rbOvenOn.Name = "rbOvenOn"
    Me.rbOvenOn.Size = New System.Drawing.Size(56, 16)
    Me.rbOvenOn.TabIndex = 0
    Me.rbOvenOn.Text = "&Bake"
    '
    'GroupBox2
    '
    Me.GroupBox2.Controls.AddRange(New System.Windows.Forms.Control() {Me.rbLightOff, Me.rbLightOn})
    Me.GroupBox2.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.GroupBox2.Location = New System.Drawing.Point(8, 136)
    Me.GroupBox2.Name = "GroupBox2"
    Me.GroupBox2.Size = New System.Drawing.Size(168, 48)
    Me.GroupBox2.TabIndex = 5
    Me.GroupBox2.TabStop = False
    Me.GroupBox2.Text = "Oven Light:"
    '
    'rbLightOff
    '
    Me.rbLightOff.Location = New System.Drawing.Point(88, 24)
    Me.rbLightOff.Name = "rbLightOff"
    Me.rbLightOff.Size = New System.Drawing.Size(56, 16)
    Me.rbLightOff.TabIndex = 1
    Me.rbLightOff.Text = "O&ff"
    '
    'rbLightOn
    '
    Me.rbLightOn.Location = New System.Drawing.Point(8, 24)
    Me.rbLightOn.Name = "rbLightOn"
    Me.rbLightOn.Size = New System.Drawing.Size(56, 16)
    Me.rbLightOn.TabIndex = 0
    Me.rbLightOn.Text = "&On"
    '
    'GroupBox3
    '
    Me.GroupBox3.Controls.AddRange(New System.Windows.Forms.Control() {Me.rbDoorClosed, Me.rbDoorOpen})
    Me.GroupBox3.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.GroupBox3.Location = New System.Drawing.Point(8, 192)
    Me.GroupBox3.Name = "GroupBox3"
    Me.GroupBox3.Size = New System.Drawing.Size(168, 48)
    Me.GroupBox3.TabIndex = 6
    Me.GroupBox3.TabStop = False
    Me.GroupBox3.Text = "Oven Door:"
    '
    'rbDoorClosed
    '
    Me.rbDoorClosed.Location = New System.Drawing.Point(88, 24)
    Me.rbDoorClosed.Name = "rbDoorClosed"
    Me.rbDoorClosed.Size = New System.Drawing.Size(56, 16)
    Me.rbDoorClosed.TabIndex = 1
    Me.rbDoorClosed.Text = "&Closed"
    '
    'rbDoorOpen
    '
    Me.rbDoorOpen.Location = New System.Drawing.Point(8, 24)
    Me.rbDoorOpen.Name = "rbDoorOpen"
    Me.rbDoorOpen.Size = New System.Drawing.Size(56, 16)
    Me.rbDoorOpen.TabIndex = 0
    Me.rbDoorOpen.Text = "O&pen"
    '
    'btnUpdate
    '
    Me.btnUpdate.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnUpdate.Location = New System.Drawing.Point(200, 8)
    Me.btnUpdate.Name = "btnUpdate"
    Me.btnUpdate.Size = New System.Drawing.Size(80, 24)
    Me.btnUpdate.TabIndex = 7
    Me.btnUpdate.Text = "&Update"
    '
    'btnExit
    '
    Me.btnExit.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnExit.Location = New System.Drawing.Point(200, 40)
    Me.btnExit.Name = "btnExit"
    Me.btnExit.Size = New System.Drawing.Size(80, 24)
    Me.btnExit.TabIndex = 8
    Me.btnExit.Text = "E&xit"
    '
    'txtOvenTemp
    '
    Me.txtOvenTemp.Location = New System.Drawing.Point(109, 40)
    Me.txtOvenTemp.Name = "txtOvenTemp"
    Me.txtOvenTemp.ReadOnly = True
    Me.txtOvenTemp.Size = New System.Drawing.Size(64, 20)
    Me.txtOvenTemp.TabIndex = 10
    Me.txtOvenTemp.Text = "txtOvenTemp"
    '
    'Label2
    '
    Me.Label2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label2.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label2.Location = New System.Drawing.Point(8, 40)
    Me.Label2.Name = "Label2"
    Me.Label2.Size = New System.Drawing.Size(100, 20)
    Me.Label2.TabIndex = 9
    Me.Label2.Text = "Oven Temp: "
    Me.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'frmOvenTest
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(292, 245)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.txtOvenTemp, Me.Label2, Me.btnExit, Me.btnUpdate, Me.GroupBox3, Me.GroupBox2, Me.GroupBox1, Me.txtTemp, Me.Label1})
    Me.Name = "frmOvenTest"
    Me.Text = "Oven simulation"
    Me.GroupBox1.ResumeLayout(False)
    Me.GroupBox2.ResumeLayout(False)
    Me.GroupBox3.ResumeLayout(False)
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub btnUpdate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
    ' Purpose:  This button acts upon the state of the oven data as set
    '           by the radio buttons and the text boxes.


    If CheckSettings() = False Then   ' See if everything in proper state
      Exit Sub
    End If
    If rbOvenOff.Checked = True Then
      txtTemp.Text = "0"
    End If

    UpdateOvenTemperature()

    txtTemp.Text = txtOvenTemp.Text

  End Sub

  Private Sub UpdateOvenTemperature()
    ' Purpose:  This routine compares the current oven temperature to
    '           the desired temperature and updates it. To add a little
    '           realism to the process, the change is delayed by using
    '           the VBN DateDiff() function.
    '
    ' Argument list:
    '   None
    '
    ' Return value:
    '   N/A

    Dim Start, Finish As Double
    Dim NewDate As Date
    Dim StartTemp, EndTemp, DiffTemp, Increments, Offset As Integer

    StartTemp = CInt(txtOvenTemp.Text)
    EndTemp = CInt(txtTemp.Text)
    Increments = 5
    Offset = 5
    DiffTemp = EndTemp - StartTemp

    If DiffTemp < 0 Then          ' If we are decreasing the temp
      DiffTemp = 0 - DiffTemp     ' Make it positive
      Increments = -5             ' Count down rather than up
    End If

    While DiffTemp > 0
      NewDate = DateAdd(DateInterval.Second, 1, Now)  ' Delay about a second
      While DateDiff(DateInterval.Second, Now, NewDate) > 0
        ' An empty loop
      End While
      StartTemp += Increments
      DiffTemp -= Offset
      txtOvenTemp.Text = CStr(StartTemp)
      Me.Update()                                   ' Update the form
    End While

  End Sub

  Private Function CheckSettings() As Integer
    ' Purpose:  This subroutine simply checks to see if all
    '           of the radio buttons are consistent with
    '           the action being done
    '
    ' Argument list:
    '   N/A
    '
    ' Return value:
    '   integer   True if OK, False otherwise

    ' Is the oven on?
    If rbOvenOff.Checked = True Then
      txtTemp.Text = "0"
      txtOvenTemp.Text = "0"
      MessageBox.Show("The oven is off")
      Return False
    End If
    ' Broiling usually has oven door open
    If rbDoorClosed.Checked = True And rbBroil.Checked = True Then
      MessageBox.Show("Probably should open the oven door")
      If txtTemp.Text = 0 Then
        txtTemp.Text = BROILTEMP
      End If
      Return False
    End If

    ' If they are baking or self-cleaning, close the door
    If rbDoorClosed.Checked = False And rbBroil.Checked <> True Then
      If rbClean.Checked = False Then
        Beep()
        MessageBox.Show("Things bake faster with oven door closed")
        Return False
      End If
    End If

    ' Show the temperature
    If rbDoorClosed.Checked = False And rbBroil.Checked = True Then
      txtTemp.Text = BROILTEMP
      Return True
    End If

    ' If we are cleaning the oven...
    If rbDoorClosed.Checked = False And rbClean.Checked = True Then
      Beep()
      MessageBox.Show("Close door during self-cleaning")
      Return False
    End If

    ' ...set the temperature to the max.
    If rbDoorClosed.Checked = True And rbClean.Checked = True Then
      txtTemp.Text = CLEANTEMP
      Return True
    End If

    Return True

  End Function

  Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    InitializeOven(MyOven)
  End Sub

  Private Sub InitializeOven(ByVal MyOven As COven)
    ' Purpose:  This sets up the starting state of the oven as shown by
    '           the text boxes.
    '
    ' Arguement list:
    '   MyOven        a COven object. This does not really need to be
    '                 passed in since it has module scope. However,
    '                 doing it this way would allow us to change its
    '                 scope and still be able to use this procedure
    '                 without changing this code.
    '
    ' Return value:
    '   N/A

    If MyOven.OvenStatus = 0 Then     ' Show oven status
      rbOvenOff.Checked = True
    Else
      rbOvenOn.Checked = True
    End If

    If MyOven.DoorStatus = 0 Then     ' Show door status
      rbDoorClosed.Checked = True
    Else
      rbDoorOpen.Checked = True
    End If

    If MyOven.DoorStatus = 0 Then     ' Show door status
      rbDoorClosed.Checked = True
    Else
      rbDoorOpen.Checked = True
    End If

    If MyOven.LightStatus = 0 Then    ' Oven light
      rbLightOff.Checked = True
    Else
      rbLightOn.Checked = True
    End If

    txtTemp.Text = CStr(MyOven.Temperature)     ' Temperature
    txtOvenTemp.Text = CStr(MyOven.Temperature)
  End Sub

  Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
    Me.Dispose()
  End Sub

  ' ================= The radio buttons =========================
  Private Sub rbOvenOn_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbOvenOn.Leave
    rbOvenOn.Checked = True
    MyOven.OvenStatus = True
  End Sub

  Private Sub rbOvenOff_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbOvenOff.Leave
    rbOvenOff.Checked = True
    MyOven.OvenStatus = False
  End Sub

  Private Sub rbLightOn_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbLightOn.Leave
    rbLightOn.Checked = True
    MyOven.LightStatus = True
  End Sub

  Private Sub rbLightOff_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbLightOff.Leave
    rbLightOff.Checked = True
    MyOven.LightStatus = False
  End Sub

  Private Sub rbDoorOpen_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbDoorOpen.Leave
    rbDoorOpen.Checked = True
    MyOven.DoorStatus = True
  End Sub

  Private Sub rbDoorClosed_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbDoorClosed.Leave
    rbDoorClosed.Checked = True
    MyOven.DoorStatus = False

  End Sub

  Private Sub rbBroil_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbBroil.Leave
    If rbDoorClosed.Checked = True And rbBroil.Checked = True Then
      MessageBox.Show("Probably should open the oven door")
      Exit Sub
    End If
    MyOven.Broil()
    txtTemp.Text = BROILTEMP
  End Sub

  Private Sub rbClean_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbClean.Leave
    MyOven.SelfClean()
    txtTemp.Text = CLEANTEMP
  End Sub

  ' ============= the text boxes ========================

  Private Sub txtTemp_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles txtTemp.Leave
    If txtTemp.Text = "0" Then
      MyOven.Temperature = 0
      rbOvenOff.Checked = True
    End If
  End Sub

End Class
